﻿uses
  Common, Classes, DataEntry, DataStorage, Regex, SysUtils;

function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
const
  BMY = 'My Bookmarks';
  BS = '\';
var
  BMEntryList: TList;
  bmEntry: TEntry;
  i: integer;
begin
  Result := -1; // Exclude

  if assigned(anEntry) and anEntry.IsBookmarked then
  begin
    BMEntryList := GetBookMarkList(anEntry);
    try
      if assigned(BMEntryList) and (BMEntryList.Count > 0) then
      begin
        for i := 0 to BMEntryList.Count - 1 do
        begin
          bmEntry := TEntry(BMEntryList.items[i]);
          if (POS(BMY + BS + 'Hash Match' + BS + 'Hash Matched' + BS, bmEntry.FullPathName) > 0) then
            Result := 1 // Include;
        end;
      end;
    finally
      if assigned(BMEntryList) then
        BMEntryList.free;
    end;
  end;
end;

begin

end.
